// TCScanDlg.cpp : implementation file
//

#include "stdafx.h"
#include "TCScan.h"
#include "TCScanDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTCScanDlg dialog

CTCScanDlg::CTCScanDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTCScanDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTCScanDlg)
	m_resource = _T("");
	m_startChan = 0;
	m_stopChan = 0;
	m_status = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTCScanDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTCScanDlg)
	DDX_Control(pDX, IDC_LIST1, m_listBox);
	DDX_Control(pDX, IDC_START, m_startScan);
	DDX_Control(pDX, IDC_SETUP_SCAN, m_setupScan);
	DDX_Text(pDX, IDC_RESOURCE, m_resource);
	DDX_Text(pDX, IDC_START_CHAN, m_startChan);
	DDV_MinMaxUInt(pDX, m_startChan, 101, 120);
	DDX_Text(pDX, IDC_STOP_CHAN, m_stopChan);
	DDV_MinMaxUInt(pDX, m_stopChan, 102, 140);
	DDX_Text(pDX, IDC_STATUS, m_status);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTCScanDlg, CDialog)
	//{{AFX_MSG_MAP(CTCScanDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_INITIALIZE, OnInitialize)
	ON_BN_CLICKED(IDC_SETUP_SCAN, OnSetupScan)
	ON_BN_CLICKED(IDC_START, OnStartScan)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTCScanDlg message handlers

BOOL CTCScanDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	 //For RS-232 use: "ASRL1::INSTR"
     //For TCP/IP (2701 only) use: "TCPIP::192.68.1.10::1394::SOCKET"
	 //For GPIB use: "GPIB1::16::INSTR"

	// set our resource and start, stop to initial values
	 m_resource.Format("%s","ASRL1::INSTR");
	 m_startChan = 101;
	 m_stopChan = 110;
	 vi = 0;  // set the session variable equal to something

	 UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTCScanDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTCScanDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CTCScanDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CTCScanDlg::OnInitialize() 
{
/*
  this application was written with MSVC++ 6 in Win2000 SP1 using
  KPCI-488, 2700 mainframe with B04 FW, 7700 card in Slot 1

  the IVI driver was version 2700-852B01.3

  Since the GPIB interface was used, the resource name in the InitWithOptions
  function was "GPIB1::16::INSTR"....instr at addr 16
  For RS-232 use: "ASRL1::INSTR"
  For TCP/IP (2701 only) use: "TCPIP::192.68.1.10::1394::SOCKET"

  The above are only examples of valid resource strings and may require
  modification based upon the specifics of your iterface/configuration

  NOTE for Ines PCMCIA card users:  your GPIB bus will be GPIB1 not GPIB0

  National Instruments card users:  your GPIB bus will usually be GPIB0

  */

	// initialize the session
	//ViStatus nErr;
	vi = new ViSession();
	char OPTIONSTRING[256] = "Simulate=0,RangeCheck=1,QueryInstrStatus=1,Cache=1";

	// TO DO:  read in the resource name to use
	

nErr = KE2700_InitWithOptions("ASRL1::INSTR", VI_TRUE, VI_TRUE,OPTIONSTRING,vi);   
						// change resource name as necessary for your connection type

// below is an alternate means to init the session, but without
// the option string you have less control over the IVI driver

//nErr = KE2700_init("GPIB1::16::INSTR",VI_TRUE,VI_TRUE,vi);

if (nErr != 0)
{ DisplayError(*vi,nErr);}
else
{
	// enable our other buttons if no error
	m_setupScan.EnableWindow(TRUE);
	//m_close.EnableWindow(TRUE);
}	
}

void CTCScanDlg::DisplayError(ViSession sesn, ViStatus nErr)
{
	ViStatus  error = VI_SUCCESS;
    ViChar    msgStr[256];  
    ViInt32   bufSize=256;

KE2700_error_message(*vi,nErr,msgStr);


	CString temp;
	temp.Format("Status = %s",msgStr);
	m_status.Format("%s",msgStr);
	UpdateData(FALSE);
//AfxMessageBox(temp);
//KE2700_GetAttributeViString(*vi, "", KE2700_ATTR_ERROR_QUEUE_NEXT, bufSize, msgStr);

}


void CTCScanDlg::OnSetupScan() 
{
	ViReal64  trigDelay=0.1;


    ViInt32   arraySize=TOTAL_READINS,  actualPts=0;  
    ViInt32   trigCount=1, sampleCount=TOTAL_READINS, i=0;
    ViInt32   tmStampType=KE2700_VAL_TIMESTAMP_RELATIVE;
    ViInt32   bufElements=KE2700_VAL_ELEMENT_READING;  // Reading Only

    // configure the temperature unit,  KE2700_ATTR_TEMP_UNIT is not channel-based.
nErr = KE2700_SetAttributeViInt32(*vi, VI_NULL, KE2700_ATTR_TEMP_UNIT, 
								  KE2700_VAL_TEMP_CELSIUS); // deg C
    // configure the tenperature measurement
nErr = KE2700_ConfigureMeasurement (KE2700_ChannelList(*vi,SCAN_CHANNEL_LIST), 
									KE2700_VAL_TEMPERATURE, 
									KE2700_VAL_AUTO_RANGE_ON, 0.0001);
	// Configure the temperature transducer type as Thermocouple,
nErr = KE2700_ConfigureTransducerType(KE2700_ChannelList(*vi,SCAN_CHANNEL_LIST), 
									  KE2700_VAL_THERMOCOUPLE);
    // configure the thermocouple type and reference junction type
nErr = KE2700_ConfigureThermocouple(KE2700_ChannelList(*vi,SCAN_CHANNEL_LIST), 
									KE2700_VAL_TEMP_TC_K, 
									KE2700_VAL_TC_REF_INTERNAL);
 	
   	// Configure the PLC for Temperature channels
nErr = KE2700_ConfigureApertureTimeInfo(KE2700_ChannelList(*vi,SCAN_CHANNEL_LIST), 
										KE2700_VAL_RATE_MEDIUM, 
										KE2700_VAL_POWER_LINE_CYCLES);
 	// Configure the filter for Temperature channels
nErr = KE2700_ConfigureFilter(KE2700_ChannelList(*vi,SCAN_CHANNEL_LIST), 
							  KE2700_VAL_FILTER_REPEATING, 10, 0.1, VI_TRUE);
// Select the Time Stamp: Relative Time Clock
nErr = KE2700_SetAttributeViInt32(*vi, VI_NULL, KE2700_ATTR_BUF_TIMESTAMP_TYPE, 
								  tmStampType);
// Select Buffer Elemnets: Readings only
nErr = KE2700_SetAttributeViInt32(*vi, VI_NULL, KE2700_ATTR_BUF_ELEMENTS, bufElements); 
                                        

// trigger delay: 0.1; trigger count: 1; Sample count:TOTAL_READINS 

nErr = KE2700_ConfigureTrigger (*vi, KE2700_VAL_IMMEDIATE, trigDelay);

nErr = KE2700_ConfigureMultiPoint (KE2700_ChannelList(*vi,SCAN_CHANNEL_LIST), trigCount, 
								   sampleCount, KE2700_VAL_IMMEDIATE, 0.0);

nErr = KE2700_ConfigureTrigger (*vi, KE2700_VAL_IMMEDIATE, 0);

nErr = KE2700_ConfigureMultiPoint (KE2700_ChannelList(*vi,SCAN_CHANNEL_LIST), trigCount, 
								sampleCount, KE2700_VAL_IMMEDIATE, 0.0);

 	//Set Buffer Size and behavior

	// Enable the auto buffer clear
 nErr = KE2700_SetAttributeViBoolean (*vi, "", KE2700_ATTR_BUF_AUTO_CLR_ENABLED, VI_TRUE);
 	// set buffer size 
 nErr = KE2700_SetAttributeViInt32 (*vi, "", KE2700_ATTR_BUF_SIZE, TOTAL_READINS);
  	// Enable Buffer as next
 nErr = KE2700_SetAttributeViInt32 (*vi, "", KE2700_ATTR_BUF_DATA_CONTROL, KE2700_VAL_CONTROL_NEXT);
 	

m_startScan.EnableWindow(TRUE);
	
}

void CTCScanDlg::OnStartScan() 
{
	// TODO: Add your control notification handler code here
	ViReal64  maxTime;
	ViInt32   retSize=0;

	KE2700_Initiate (*vi);


 	// calculate the max waiting time 
 	maxTime =   60000; //TOTAL_READINS * trigDelay * 1000 +
 	// Fetch the readings
 	nErr = KE2700_FetchMultiPoint (*vi, maxTime, 80*TOTAL_READINS, rdBuffer, &retSize);

	int index;
	CString str;
	for(index=0;index<TOTAL_READINS;index++)
	{
		str.Format("%8.3f",rdBuffer[index]);  //Format the sample as a string to display it in the listbox
		m_listBox.AddString(str); //Add the current sample to the listbox
	}
	UpdateData(FALSE); //Update the listbox display
	
}



void CTCScanDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// as program exits, release the session....if it had been opened

	if (vi != NULL) KE2700_close (*vi);
	
}
